#!/usr/bin/env bash

# ---
# Arguments
# ---

instanceNumber=$1
numberOfInstances=$2
regionName=$3

# ---
# Consul configuration
# ---

cat > /etc/consul.d/consul.hcl <<EOF
datacenter = "dc-$regionName-1"
data_dir = "/opt/consul"

node_name = "consul-server-$instanceNumber"

bind_addr = "0.0.0.0"
client_addr = "0.0.0.0"
advertise_addr = "10.8.0.$instanceNumber"

bootstrap_expect = $numberOfInstances

server = true
ui = true

retry_join = [
EOF

for SERVER_NUMBER in $(seq 1 $numberOfInstances); do
    echo "    \"10.8.0.$SERVER_NUMBER\"," >> /etc/consul.d/consul.hcl
done

cat >> /etc/consul.d/consul.hcl <<EOF
]

service {
    name = "consul"
}

connect {
    enabled = true
}

ports {
    grpc = 8502
}
EOF

# ---
# Nomad configuration
# ---

cat > /etc/nomad.d/nomad.hcl <<EOF
datacenter = "dc-$regionName-1"
data_dir = "/opt/nomad/data"

bind_addr = "0.0.0.0"

name = "nomad-server-$instanceNumber"

server {
    enabled = true
    bootstrap_expect = $numberOfInstances
}

consul {
    address = "127.0.0.1:8500"
}
EOF

# ---
# Running Consul
# ---
systemctl enable consul
systemctl start consul

# ---
# Running Nomad
# ---
systemctl enable nomad
systemctl start nomad
